function downloadCSV() {
	let data = [];
	let rows = document.getElementsByClassName('exportable');
	for (let i = 0; i < rows.length; i++) {
		data.push(rows[i].innerHTML);
	}

	data = data.join('\n');

	CSVFile = new Blob([data], {
		type: "text/csv"
	});
	
	let temp_link = document.createElement('a');
	temp_link.download = "report_NAME_00.csv";
	let url = window.URL.createObjectURL(CSVFile);
	temp_link.href = url;
	temp_link.style.display = "none";
	document.body.appendChild(temp_link);
	temp_link.click();
	document.body.removeChild(temp_link);
}

function uploadCSV(event) {
	if (confirm("Warning: The current report will be entirely replaced. Proceed?") == true){
		let input = event.target;
		let file = input.files[0];
		let reader = new FileReader();
		reader.readAsText(file);
		reader.onload = function(event){
			var data = event.target.result;
			var rowData = data.split("\n");
			console.log(rowData);
			
			let y = 0;
			let elems = document.getElementsByClassName("exportable");
			for (let i = 0; i < elems.length; i++) {
				elems[i].innerHTML = rowData[y];
				y++;
			}
		}
	}
}

function openTab(event, partnb) {
  let i, tabcontent, tablinks;

  tabcontent = document.getElementsByClassName("editpart");
  for (i = 0; i < tabcontent.length; i++) {
    tabcontent[i].style.display = "none";
  }

  tablinks = document.getElementsByClassName("tablinks");
  for (i = 0; i < tablinks.length; i++) {
    tablinks[i].className = tablinks[i].className.replace(" active", "");
  }

  document.getElementById(partnb).style.display = "block";
  event.currentTarget.className += " active";
}

function closingWarning() {
	return "Have you saved your report? Make sure to save all changes before closing this page.";
}